<?php

  set_time_limit ( 0 );
  error_reporting( 0 );



  define( 'ON_SITE', true );
  define( 'ABS_PATH', dirname( __FILE__ ) . '/' );


  /**
  * Include important files
  **/
  require( ABS_PATH . 'includes/config.php' );
  require( ABS_PATH . 'includes/mycurl_class.php' );
  require( ABS_PATH . 'includes/mysql_class.php' );
  require( ABS_PATH . 'includes/class_xml_check.php' );


  /**
  * Set default cURL options and connect to the database
  **/
  try
  {
    $curl = new myCURL();
    $curl->setDefaultOptions( array(
      CURLOPT_CRLF => true,
      CURLOPT_FRESH_CONNECT => true,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_CONNECTTIMEOUT => SETUP_CONNECTION_TIMEOUT,
      CURLOPT_TIMEOUT => SETUP_TIMEOUT,
      CURLOPT_BINARYTRANSFER => true,
      CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows; U; Windows NT 5.1; pl; rv:1.8.1.3) Gecko/20070309 Firefox/2.0.0.3'
    ) );

    $db = new mysql();
  }
  catch (Exception $e) { die( $e->getMessage() ); }

  /**
  * Setting posts filter
  **/
  if( SETUP_POST_TITLES_FILTER != '' )
  {
    $keywords = preg_split( '/\s*,\s*/', strtolower( SETUP_POST_TITLES_FILTER ) );

    $filter = '(';
    for( $i=0,$c=count( $keywords ); $i<$c; $i++ ) {
      $filter .= preg_quote( $keywords[$i] ) . '|';
    }
    $filter = substr_replace( $filter, ')', -1 );
  }




  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /
  // PART 1                                                                    /
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /


  /**
  * Create temporary file for weblogs.com XML data
  **/
  $tempFile = tempnam( ABS_PATH . SETUP_TEMP_DIR, 'xml_' );

  /**
  * Connect to weblogs.com and save XML file in temp file
  **/
  $curl->setOptions( CURLOPT_URL, SETUP_XML_URL );
  $curl->init();

  if( !$curl->exec() )
  {
    $curl->close();
    sleep( SETUP_SLEEP_SECONDS );
      continue;
  }
  file_put_contents( $tempFile, $curl->ret );
  $curl->free();



  /**
  * Read XML data from temp file
  **/
  $xml = new XMLReader();
  $xml->open( $tempFile );
  while( $xml->read() )
  {
    if( $xml->name == 'weblog' )
    {
      /**
      * Filter blog's name
      **/
      $name = $xml->getAttribute( 'name' );
      $name = utf8_decode( $name );
      $unknownChars = preg_replace( '/[ ->@-~]/', '',  $name );
      $unknownCharsCount = strlen( $unknownChars );
      if( ( $unknownCharsCount > 10 ) || ( $unknownCharsCount / strlen( $name ) ) >= 0.35 ) {
        continue; // Too many non-ISO-8859-1 chars.
      }

      $url = $db->escape( $xml->getAttribute( 'url' ) );
      $when = intval( $xml->getAttribute( 'when' ) );

      /**
      * Check if URL already exists in database
      **/
      try
      {
        $db->query( "SELECT `when`, `checked` FROM `blogs2check` WHERE (`url` = '{$url}')" );
      } catch (Exception $e) { die( $e->getMessage() ); }
      $row = $db->fetch();

      if( !empty( $row ) )
      {
        // URL exists, but needs update
        if( ( $row['checked'] == '1' ) && ( $when < $row['when'] ) ) {
          $db->uquery( "UPDATE `blogs2check` SET `checked` = '0', `when` = {$when}, `update_time` = " . time() . " WHERE (`url` = '{$url}')" );
        }
      }
      else {
        // URL not exists, insert
        $db->uquery( "INSERT INTO `blogs2check` SET `url` = '{$url}', `when` = {$when}, `update_time` = " . time() );
      }
    }#endIf
  }#endWhile

  /**
  * Temp file is no more needed
  **/
  unlink( $tempFile );




  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /
  // PART 2                                                                    /
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /


  /**
  * Delete old checked blogs
  **/
  $db->uquery( "DELETE FROM `blogs2check` WHERE (`update_time` < " . ( time() - 360 ) . ") AND (`checked` = '1')" );

  /**
  * Get list of unchecked blogs
  **/
  try {
    $result = $db->query( "SELECT `url` FROM `blogs2check` WHERE (`checked` = '0') ORDER BY `update_time` ASC" );
  } catch (Exception $e) { die( $e->getMessage() ); }

  while( $row = $db->fetch( $result ) )
  {
    $url = $db->escape( $row['url'] );


    /**
    * Connect to the blog
    **/
    $curl->setOptions( CURLOPT_URL, $row['url'] );
    $curl->init();
    if( !$curl->exec() )
    {
      $curl->close();
      $db->uquery( "UPDATE `blogs2check` SET `checked` = '1' WHERE (`url` = '{$url}')" );

      continue;
    }

    /**
    * Check if blog contains RSS feed
    **/
    if( !preg_match( '/<link[^>]+(?:rel\s*=\s*("|\')?alternate(?:\\1).*?type\s*=\s*("|\')?(?:application|text)\\/(?:rss(?:\\+xml)?)(?:\\2)|type\s*=\s*("|\')?(?:application|text)\\/(?:rss(?:\\+xml)?)(?:\\3).*?rel\s*=\s*("|\')?alternate(?:\\4))[^>]*>/si', $curl->ret, $sub ) )
    {
      $db->uquery( "UPDATE `blogs2check` SET `checked` = '1' WHERE (`url` = '{$url}')" );
      continue;
    }
    if( !preg_match( '/href\s*=\s*("|\')?(.*?)(?(1)("|\')|\s)/si', $sub[0], $sub2 ) )
    {
      $db->uquery( "UPDATE `blogs2check` SET `checked` = '1' WHERE (`url` = '{$url}')" );
      continue;
    }
    $curl->close();

    if( substr( $sub2[2], 0, 7 ) == 'feed://' ) {
      $sub2[2] = 'http://' . substr( $sub2[2], 7 );
    }
    elseif( !preg_match( '/^https?:\\/\\//i', $sub2[2] ) ) {
      $sub2[2] = dirname( $url ) . '/' . $sub2[2];
    }


    /**
    * Get blog's RSS feed
    **/
    $curl->setOptions( CURLOPT_URL, trim( $sub2[2] ) );
    $curl->init();
    if( !$curl->exec() )
    {
      $curl->close();
      $db->uquery( "UPDATE `blogs2check` SET `checked` = '1' WHERE (`url` = '{$url}')" );

      continue;
    }

    /**
    * Remove headers and unnecessary content.
    * Then check if RSS is valid.
    **/
    $curl->ret = preg_replace( '/<\\?.*?\\?>/', '', $curl->ret );
    $curl->ret = preg_replace( '/<!--.*?!>/', '', $curl->ret );
    $curl->ret = ltrim( $curl->ret );
    $checkXML = new XML_check();
    if( !$checkXML->check_string( $curl->ret ) )
    {
      $curl->close();
      $db->uquery( "UPDATE `blogs2check` SET `checked` = '1' WHERE (`url` = '{$url}')" );

      continue;
    }

    /**
    * Parse RSS feed and store all post titles in database
    **/
    try {
      $xml = new SimpleXMLElement( $curl->ret );
    }
    catch (Exception $e)
    {
      /**
      * Fatal error in parsing XML file? Loopback.
      **/
      $db->uquery( "UPDATE `blogs2check` SET `checked` = '1' WHERE (`url` = '{$url}')" );

      $fp = fsockopen( $_SERVER['SERVER_ADDR'], 80 );
      if( !is_resource( $fp ) ) {
        die( 'Loopback failed' );
      }

      fwrite( $fp, "GET {$_SERVER['PHP_SELF']} HTTP/1.1\r\nHost: {$_SERVER['SERVER_NAME']}\r\n\r\n" );
      fclose( $fp );
    }
    $curl->close();

    $c = count( $xml->channel->item );
    for( $i=0; $i<$c; $i++ )
    {
      $title = (string) $xml->channel->item[$i]->title;
      $desc = (string) $xml->channel->item[$i]->description;
      $desc = str_ireplace( array( '<![CDATA[', ']]>' ), '', $desc );
      $desc = preg_replace( '/("|\'|&quot;)?https?:\\/\\/.*?((?(1)\\1|(\\s|>|&gt;)))/si', '\\1' . SETUP_SITE_URL . '\\2', $desc );

      /**
      * Filter post's title
      **/
      $unknownChars = preg_replace( '/[ ->@-~]/', '',  $title );
      $unknownCharsCount = strlen( $unknownChars );
      if( ( $unknownCharsCount > 10 ) || ( $unknownCharsCount / strlen( $title ) ) >= 0.35 ) {
        continue; // Too many non-ISO-8859-1 chars.
      }
      if( isset( $filter ) )
      {
        if( !preg_match( '/' . $filter . '/si', $title ) && !preg_match( '/' . $filter . '/si', $desc ) ) {
          continue; // Rewuired keywords not found
        }
      }

      $title = $db->escape( $title );
      $desc = $db->escape( $desc );
      if( empty( $title ) && empty( $desc ) ) {
        continue;
      }

      $db->uquery( "INSERT INTO `post_titles` SET `title` = '{$title}', `content` = '{$desc}'" );
    }
    $db->uquery( "UPDATE `blogs2check` SET `checked` = '1' WHERE (`url` = '{$url}')" );




    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /
    // PART 3                                                                  /
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /

    /**
    * Check the number of unused post titles
    **/
    try {
      $db->query( "SELECT COUNT(*) AS `count` FROM `post_titles` WHERE (`used` = '0')" );
    }
    catch (Exception $e) { die( $e->getMessage() ); }

    $row = $db->fetch();
    $count = intval( $row['count'] );
    if( $count >= SETUP_POSTS_IN_FEED )
    {
      /**
      * Number of unused post titles is high enough. Create our new RSS feed(s)
      **/

      try {
        $db->query( "SELECT MAX(`feed_number`) AS `number` FROM `feeds`" );
      } catch (Exception $e) { die( $e->getMessage() ); }

      $row = $db->fetch();
      $number = intval( $row['number'] );


      $c = floor( $count / SETUP_POSTS_IN_FEED );
      for( $x=0; $x<$c; $x++ )
      {
        $number++;

        /**
        * Get proper number of unused post titles, create own posts using random content and store them in database
        **/
        try {
          $db->query( "SELECT `id`, `title`, `content` FROM `post_titles` WHERE `used` = '0' LIMIT " . SETUP_POSTS_IN_FEED );
        }
        catch (Exception $e) { die( $e->getMessage() ); }

        while( $row = $db->fetch() )
        {
          $title = $db->escape( $row['title'] );
          $post = $db->escape( $row['content'] );

          $db->uquery( "UPDATE `post_titles` SET `used` = '1' WHERE (`id` = {$row['id']})" );
          $db->uquery( "INSERT INTO `feeds` SET `title` = '{$title}', `text` = '{$post}', `feed_number` = {$number}" );
        }


        /**
        * Our new RSS feed is ready. Lets ping some services:
        **/
        $feedURL = SETUP_RSS_URL . '/rss_' . $number . '.xml';

        /**
        * 1. blogsearch.google.com
        **/
        $curl->setOptions( array(
          CURLOPT_URL => 'http://blogsearch.google.com/ping',
          CURLOPT_REFERER => 'http://blogsearch.google.com/ping',
          CURLOPT_POST => true,
          CURLOPT_POSTFIELDS => 'url=' . rawurlencode( $feedURL ) . '&btnG=Submit%20Blog&hl=en'
        ) );
        $curl->init();
        $curl->exec();
        $curl->close();

        /**
        * 2. search.yahoo.com
        **/
        $curl->setOptions( array(
          CURLOPT_URL => 'http://search.yahoo.com/mrss/submit',
          CURLOPT_REFERER => 'http://search.yahoo.com/mrss/submit',
          CURLOPT_POST => true,
          CURLOPT_POSTFIELDS => 'url_mrss=' . rawurlencode( $feedURL ) . '&class=Search&pass=1&.done=&email=&url_web=' . rawurlencode( SETUP_SITE_URL ) . '&submit=Submit%20your%20feed'
        ) );
        $curl->init();
        $curl->exec();
        $curl->close();

        /**
        * 3. daypop.com
        **/
        $curl->setOptions( array(
          CURLOPT_URL => 'http://www.daypop.com/submit_site?extra=1&url=' . rawurlencode( $feedURL . ' news' ) . '&Submit=Submit%20Site',
          CURLOPT_REFERER => 'http://www.daypop.com/info/submit.htm',
        ) );
        $curl->init();
        $curl->exec();
        $curl->close();

        /**
        * 4. pingomatic.com
        **/
        $curl->setOptions( array(
          CURLOPT_URL => 'http://pingomatic.com/ping/?title=&blogurl=' . rawurlencode( SETUP_SITE_URL ) . '&rssurl=' . rawurlencode( SETUP_RSS_URL ) . '&chk_weblogscom=on&chk_blogs=on&chk_technorati=on&chk_feedburner=on&chk_syndic8=on&chk_newsgator=on&chk_feedster=on&chk_myyahoo=on&chk_pubsubcom=on&chk_blogdigger=on&chk_blogstreet=on&chk_moreover=on&chk_weblogalot=on&chk_icerocket=on&chk_newsisfree=on&chk_topicexchange=on',
          CURLOPT_REFERER => 'http://pingomatic.com/',
        ) );
        $curl->init();
        $curl->exec();
        $curl->close();

      }#endFor
    }#endIf
  }#enwWhile




  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /
  // PART 4                                                                    /
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - /

  /**
  * Simple loopback
  **/

  $fp = fsockopen( $_SERVER['SERVER_ADDR'], 80 );
  if( !is_resource( $fp ) ) {
    die( 'Loopback failed' );
  }

  fwrite( $fp, "GET {$_SERVER['PHP_SELF']} HTTP/1.1\r\nHost: {$_SERVER['SERVER_NAME']}\r\n\r\n" );
  fclose( $fp );

?>