<?php

  if( !defined( 'ON_SITE' ) ) {
    exit();
  }



  /**
  * Simple cURL overlay
  **/
  class myCURL
  {
    private $ch;

    private $options = array();
    private $defaultOptions = array();

    public $ret = null;



    /**
    * myCURL constructor.
    * Check if cURL extension is loaded.
    **/
    public function __construct()
    {
      if( !extension_loaded( 'curl' ) && !function_exists( 'curl_init' ) ) {
        throw new  Exception( 'cURL extension not available!', 1 );
      }
    }

    /**
    * myCURL desctructor.
    * Tidy up.
    **/
    public function __destruct()
    {
      $this->close();
    }


    /**
    * Initializes the cURL engine
    **/
    public function init()
    {
      $this->ch = curl_init();
    }

    /**
    * Setting the default and the common options and executing request.
    * Returns flase on error and true on success
    **/
    public function exec()
    {
      if( !is_resource( $this->ch ) ) {
        throw new Exception( 'cURL not initialized!', 2 );
      }


      foreach( $this->defaultOptions as $key => $item ) {
        curl_setopt( $this->ch, $key, $item );
      }
      foreach( $this->options as $key => $item ) {
        curl_setopt( $this->ch, $key, $item );
      }

      $this->ret = curl_exec( $this->ch );
      if( curl_errno( $this->ch ) != 0 )
      {
        $this->close();
        return( false );
      }

      return( true );
    }


    /**
    * Free memory
    **/
    public function free()
    {
      $this->ret = null;
    }


    /**
    * Close connection if exists and tidy up
    **/
    public function close()
    {
      $this->options = array();
      $this->free();

      if( is_resource( $this->ch ) )
      {
        curl_close( $this->ch );
        $this->ch = null;
      }
    }


    /**
    * Set common cURL options
    **/
    public function setOptions( $name, $value=null )
    {
      if( is_array( $name ) )
      {
        foreach( $name as $key => $item ) {
          $this->setOptions( $key, $item );
        }
      }
      else {
        $this->options[$name] = $value;
      }
    }

    /**
    * Set default cURL options
    **/
    public function setDefaultOptions( $name, $value=null )
    {
      if( is_array( $name ) )
      {
        foreach( $name as $key => $item ) {
          $this->setDefaultOptions( $key, $item );
        }
      }
      else {
        $this->defaultOptions[$name] = $value;
      }
    }

  }


?>